package com.agilex.healthcare.veteranappointment.clientapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

public class JerseyFactory {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(JerseyFactory.class);

	public static javax.ws.rs.client.Client createJerseyClient() {
		AnnotationIntrospector jaxbAnnotationIntrospector = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
		AnnotationIntrospector jacksonAnnotationIntrospector = new JacksonAnnotationIntrospector();

		ObjectMapper objectMapper = new ObjectMapper()
				.configure(SerializationFeature.INDENT_OUTPUT, true)
				.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)
				.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
				.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false)
				.setSerializationInclusion(JsonInclude.Include.NON_NULL)
				.setAnnotationIntrospectors(jacksonAnnotationIntrospector, jaxbAnnotationIntrospector);

		JacksonJsonProvider jacksonJsonProvider = new JacksonJaxbJsonProvider()
				.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

		ClientConfig config = new ClientConfig();
		config.register(objectMapper);

		Client jerseyclient = ClientBuilder.newClient(config);     //new com.sun.jersey.api.client.Client();

		logger.debug("creating jersey client");

			jerseyclient.register(JacksonFeature.class);
			jerseyclient.register(jacksonJsonProvider);

		return jerseyclient;
	}
}
